%% Script that analyses self-perceived "EMA" data
clear,clc,close all

%% Read raw data
load('Self_Perceived')
NH = (NH1+NH2)'/2;          % Mean scores for NH
UHL = (UHL1+UHL2)'/2;       % Mean scores for UHL
clear NH1 NH2 UHL1 UHL2

%% Process data
% Get Mean (column 17) and standard error (column 18) per question
NH(17,:)  = mean(NH,1);
NH(18,:)  = std(NH,1)/sqrt(16);
UHL(17,:) = mean(UHL,1);
UHL(18,:) = std(UHL,1)/sqrt(16);
save('SP_AvScores','NH','UHL')

% Statistical analysis
p_SP = nan(10,1);
for k=1:10
    [~,p_SP(k)] = ttest2(NH(:,k),UHL(:,k));
end

%% Figure
FS = 26; sep = 0.1;
figure('PaperSize',[40 20]),hold on,box on, grid on

hv = barh([fliplr(NH(17,:)) ; fliplr(UHL(17,:))]');
errorbar(fliplr(UHL(17,:)),(1:10)+0.14,fliplr(UHL(18,:)),...
    'horizontal','k','LineStyle','none','LineWidth',1.5)
errorbar(fliplr(NH(17,:)),(1:10)-0.14,fliplr(NH(18,:)),...
    'horizontal','k','LineStyle','none','LineWidth',1.5)
text(4.6,10-sep,'*','FontSize',FS+15,'HorizontalAlignment','center')
text(4.6,09-sep,'***','FontSize',FS+15,'HorizontalAlignment','center')
text(4.6,08-sep,'**','FontSize',FS+15,'HorizontalAlignment','center')
text(4.6,07-sep,'***','FontSize',FS+15,'HorizontalAlignment','center')
text(4.6,06-sep,'**','FontSize',FS+15,'HorizontalAlignment','center')
text(4.6,05-sep,'**','FontSize',FS+15,'HorizontalAlignment','center')
text(4.6,04-sep,'***','FontSize',FS+15,'HorizontalAlignment','center')
text(4.6,03-sep,'*','FontSize',FS+15,'HorizontalAlignment','center')
text(4.6,02-sep,'***','FontSize',FS+15,'HorizontalAlignment','center')
text(4.6,01+0.05,'***','FontSize',FS+15,'HorizontalAlignment','center')

lgnd = legend(hv,'NH','UHL');
set(lgnd,'FontSize',FS-8,'Location','SouthWest')

set(gca,'ytick',1:10,'FontSize',FS-1,'yticklabel',{...
    'Can you tell where the talker is coming from?',...
    'Do you miss the start of what is being said?',...
    'How mentally tired are you?',...
    'How demanding is the task?',...
    'How frustrated do you feel?',...
    'How annoying is this environment?',...
    'Does your hearing restrict your ability to listen?',...
    'How much does the noise interfere?',...
    'How much can you understand?',...
    'How noisy is it?'})
set(gca,'xtick',0:5,'FontSize',FS-1)
xlim([0 5])
xlabel('Low / Never / Little                High / Always / Much','FontSize',FS)

orient tall
print('-dpng','-r600','Figure6')
print('-dpdf','-r600','Figure6')
close all
